	function PLOT_MAG_PZ_PHASE_TG_FIR(wT, wTedges, d, Mag, h, ZerosMP, Phase, gd)
 
	% 	Plots magnitude, poles & zeros, phase and group delay in a single picture
	%	for an FIR filter
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
		
	% 	Author: 		Lars Wanhammar 2005-06-26
	% 	Modified by: 	 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1 
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
 
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================
	hold on;
		figure(1)
			subplot('position', [0.1 0.55 0.40 0.42])
			plot(wT, Mag,'linewidth', lw);   		% Magnitude response
			axis([0 pi -80 0]);
			ylabel('{|\itH}({\ite^j^\omega^T})|  [dB]','FontName', fn,'FontSize',fs);
			set(gca,'FontName', fn,'FontSize', fs);
			ax = [0 0.2*pi 0.4*pi 0.6*pi 0.8*pi pi];
			lab = {'0';'0.2\pi';'0.4\pi';'0.6\pi';'0.8\pi';'\pi'};
			xtick(ax,lab);
			grid on;
			zoom on
			% Draw specification
			color = [0.7 0.7 0.7]; % Gray
			V = axis;
			lc = V(1);
			rc = wTedges(1)*V(2)/pi;
			Amaxreq = -20*log10((1+d(1))/(1-d(1)));
			patch([lc rc rc lc lc], [Amaxreq Amaxreq V(3) V(3) Amaxreq], color);			
			lc = wTedges(2);
			rc = V(2);
			Aminreq = -20*log10((1+d(1))/d(2));
			patch([lc rc rc lc lc], [0 0 Aminreq Aminreq 0], color);	

			% Plot Phase
			subplot('position', [0.1 0.087 0.40 0.41])			 
			 PLOT_PHASE_Z(wT, Phase, -pi, pi)
			% z-plane
			subplot('position', [0.57 0.54 0.42 0.42])
			P = zeros(length(ZerosMP),1);		% All poles at z = 0
			PLOT_PZ_Z(ZerosMP, P);		
			grid on;
			
			% Group delay 
			subplot('position', [0.57 0.08 0.42 0.41]) 
			plot(wT, gd,'linewidth', lw);    					
			xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize',fs);
			ylabel('Group delay [T]');
			axis([0 pi 0 8]);		% Make axis([0 pi 0 25]); for Problem 5.21
			set(gca,'FontName', fn,'FontSize', fs);
			ax = [0 0.2*pi 0.4*pi 0.6*pi 0.8*pi pi];
			lab = {'0';'0.2\pi';'0.4\pi';'0.6\pi';'0.8\pi';'\pi'};
			xtick(ax,lab);
			grid on;
